LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY dff IS
  PORT(d, clk : IN std_logic;
       q : OUT std_logic);

  FUNCTION rising_edge(SIGNAL S : std_logic)  -- line 1
    RETURN BOOLEAN IS                         -- line 2
  BEGIN
    -- this function makes use of attributes
    -- 'event and 'last_value discussed
    -- in Chapter 6 
    IF (S'EVENT) AND (S = '1') AND            -- line 3
       (S'LAST_VALUE = '0') THEN              -- line 4
      RETURN TRUE;                            -- line 5
    ELSE
      RETURN FALSE;                           -- line 6
    END IF;
  END rising_edge;
END dff;

ARCHITECTURE behave OF dff IS
BEGIN
  PROCESS( clk)
  BEGIN
    IF rising_edge(clk) THEN                  -- line 7
      q <= d;                                 -- line 8
    END IF;
  END PROCESS;
END behave;


